/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import java.util.List;
import technology.rocketjump.undermount.input.GameWorldInputHandler;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.screens.GameScreen;
import technology.rocketjump.undermount.ui.i18n.I18nRepo;
import technology.rocketjump.undermount.ui.i18n.LanguageType;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;
import technology.rocketjump.undermount.ui.widgets.IconButton;
import technology.rocketjump.undermount.ui.widgets.IconButtonFactory;

public class MainMenuScreen
implements Screen {
    private static final float PIXEL_SCROLL_PER_SECOND = 70.0f;
    private final MessageDispatcher messageDispatcher;
    private final DebugWindow debugWindow;
    private final Skin uiSkin;
    private final List<LanguageType> allLanguages;
    private LanguageType selectedLanguage;
    private SpriteBatch basicSpriteBatch = new SpriteBatch();
    private OrthographicCamera camera = new OrthographicCamera();
    private Texture backgroundImage;
    private Texture logo;
    private float xCursor = 0.0f;
    private float pauseTime;
    private static float MAX_PAUSE_TIME = 10.0f;
    private Stage stage;
    private Table containerTable;
    private Table menuTable;
    boolean gameStarted = false;
    private final IconButton newGameButton;
    private final IconButton continueGameButton;
    private final IconButton fullscreenButton;
    private final IconButton quitButton;
    private final SelectBox<LanguageType> languageSelect;

    @Inject
    public MainMenuScreen(final MessageDispatcher messageDispatcher, DebugWindow debugWindow, GuiSkinRepository guiSkinRepository, IconButtonFactory iconButtonFactory, final I18nRepo i18nRepo) {
        this.messageDispatcher = messageDispatcher;
        this.debugWindow = debugWindow;
        this.uiSkin = guiSkinRepository.getDefault();
        this.containerTable = new Table(this.uiSkin);
        this.containerTable.setFillParent(true);
        this.containerTable.center();
        this.menuTable = new Table(this.uiSkin);
        this.menuTable.setFillParent(false);
        this.menuTable.center();
        this.newGameButton = iconButtonFactory.create("MENU.NEW_GAME", null, Color.LIGHT_GRAY, ButtonStyle.EXTRA_WIDE);
        this.newGameButton.setAction(() -> {
            this.gameStarted = true;
            messageDispatcher.dispatchMessage(2, (Object)GameScreen.INTRO);
        });
        this.continueGameButton = iconButtonFactory.create("MENU.CONTINUE_GAME", null, Color.LIGHT_GRAY, ButtonStyle.EXTRA_WIDE);
        this.continueGameButton.setAction(() -> messageDispatcher.dispatchMessage(2, (Object)GameScreen.MAIN_GAME));
        this.fullscreenButton = iconButtonFactory.create("MENU.TOGGLE_FULLSCREEN", null, Color.LIGHT_GRAY, ButtonStyle.EXTRA_WIDE);
        this.fullscreenButton.setAction(GameWorldInputHandler::toggleFullscreen);
        this.quitButton = iconButtonFactory.create("MENU.QUIT", null, Color.LIGHT_GRAY, ButtonStyle.EXTRA_WIDE);
        this.quitButton.setAction(() -> Gdx.app.exit());
        this.stage = new Stage();
        this.stage.addActor(this.containerTable);
        this.allLanguages = i18nRepo.getAllLanguages();
        this.selectedLanguage = this.allLanguages.get(0);
        this.languageSelect = new SelectBox(this.uiSkin);
        Array<LanguageType> languageEntries = new Array<LanguageType>();
        for (LanguageType language : this.allLanguages) {
            languageEntries.add(language);
        }
        this.languageSelect.setItems(languageEntries);
        this.languageSelect.setSelected(this.selectedLanguage);
        this.languageSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MainMenuScreen.this.selectedLanguage = (LanguageType)MainMenuScreen.this.languageSelect.getSelected();
                i18nRepo.setCurrentLanguage(MainMenuScreen.this.selectedLanguage);
                messageDispatcher.dispatchMessage(290);
                messageDispatcher.dispatchMessage(291);
                MainMenuScreen.this.resetTable();
            }
        });
    }

    private void resetTable() {
        this.stage.clear();
        this.containerTable.clearChildren();
        this.menuTable.clearChildren();
        Image logoImage = new Image(this.logo);
        this.menuTable.add(logoImage).width(this.logo.getWidth()).height(this.logo.getHeight()).center();
        this.menuTable.row();
        Table languageRow = new Table(this.uiSkin);
        languageRow.add(new Image(this.selectedLanguage.getIconSprite()));
        languageRow.add(this.languageSelect).padLeft(5.0f);
        this.menuTable.add(languageRow);
        this.menuTable.row();
        this.menuTable.add(this.newGameButton).pad(10.0f);
        this.menuTable.row();
        if (this.gameStarted) {
            this.menuTable.add(this.continueGameButton).pad(10.0f);
            this.menuTable.row();
        }
        this.menuTable.add(this.fullscreenButton).pad(10.0f);
        this.menuTable.row();
        this.menuTable.add(this.quitButton).pad(10.0f);
        this.menuTable.row();
        this.containerTable.add(this.menuTable).center();
        this.stage.addActor(this.containerTable);
    }

    @Override
    public void show() {
        this.backgroundImage = new RandomXS128().nextBoolean() ? new Texture("assets/main_menu/Dwarves.jpg") : new Texture("assets/main_menu/Dwarf Realm.jpg");
        this.xCursor = 0.0f;
        this.logo = new Texture("assets/main_menu/Logo.png");
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        inputMultiplexer.addProcessor(this.stage);
        inputMultiplexer.addProcessor(new MainMenuInputHandler());
        Gdx.input.setInputProcessor(inputMultiplexer);
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void hide() {
        this.backgroundImage.dispose();
        this.backgroundImage = null;
        this.logo.dispose();
        this.logo = null;
    }

    @Override
    public void render(float delta) {
        this.camera.update();
        this.stage.act();
        this.basicSpriteBatch.begin();
        this.basicSpriteBatch.setProjectionMatrix(this.camera.combined);
        float minXPosition = (float)(-(this.backgroundImage.getWidth() - Gdx.graphics.getWidth())) / 2.0f;
        this.xCursor -= delta * 70.0f;
        if (this.xCursor < minXPosition) {
            this.xCursor = minXPosition;
        }
        float yPosition = (float)(-Math.abs(this.backgroundImage.getHeight() - Gdx.graphics.getHeight())) / 4.0f;
        this.basicSpriteBatch.draw(this.backgroundImage, this.xCursor, yPosition -= 100.0f, this.xCursor + (float)this.backgroundImage.getWidth(), yPosition + (float)this.backgroundImage.getHeight());
        this.basicSpriteBatch.end();
        this.stage.draw();
        this.debugWindow.render();
        this.debugWindow.clearText();
    }

    @Override
    public void resize(int width, int height) {
        this.camera.setToOrtho(false, width, height);
        this.stage.setViewport(new ScreenViewport(new OrthographicCamera(width, height)));
        this.stage.getViewport().update(width, height, true);
        this.resetTable();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    private static class MainMenuInputHandler
    implements InputProcessor {
        private MainMenuInputHandler() {
        }

        @Override
        public boolean keyDown(int keycode) {
            return false;
        }

        @Override
        public boolean keyUp(int keycode) {
            if (keycode == 131) {
                Gdx.app.exit();
            } else if (keycode == 254) {
                GameWorldInputHandler.toggleFullscreen();
            } else {
                return false;
            }
            return true;
        }

        @Override
        public boolean keyTyped(char character) {
            return false;
        }

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchDragged(int screenX, int screenY, int pointer) {
            return false;
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            return false;
        }

        @Override
        public boolean scrolled(int amount) {
            return false;
        }
    }
}

